<?php

class OftSettings
{
    private $session;
    
    public function __construct($session)
    {
        $this->session = $session;
    }
    
    public function get_settings_sections_folder_views()
    {
        $section_default_icon_url =
            $this->session->get_icon('mov_genre_default.png');

        return array(
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 10,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_padding_top => 0,
                    ViewItemParams::item_padding_bottom => 0,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::item_caption_width => 365,
                    ViewItemParams::icon_dx => 65,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array
                (
                    ViewItemParams::icon_path => $section_default_icon_url,
                ),
            ));
    }
    
    public function folder_entered(MediaURL $media_url, &$plugin_cookies)
    {
        $this->session->ensure_logged_in($plugin_cookies);
    }
}
