<?php

class SettingsSectionsScreen extends AbstractPreloadedRegularScreen
    implements UserInputHandler
{
    const ID = 'settings_sections';

    public static function get_media_url_str()
    {
        return MediaURL::encode(array('screen_id' => self::ID));
    }

    ///////////////////////////////////////////////////////////////////////

    private $vod;

    public function __construct(Vod $vod)
    {
        $this->vod = $vod;

        parent::__construct(self::ID,
            $vod->get_vod_genres_folder_views());//get_settings_sections_folder_views());

        UserInputHandlerRegistry::get_instance()->register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
        $select_section_action =
            UserInputHandlerRegistry::create_action(
                $this, 'select_section');

        return array
        (
            GUI_EVENT_KEY_ENTER => $select_section_action,
        );
    }

    public function get_handler_id()
    { return self::ID; }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        hd_print('Settings sections: handle_user_input:');
        foreach ($user_input as $key => $value)
            hd_print("  $key => $value");

        if ($user_input->control_id == 'select_section')
        {
            return ActionFactory::show_title_dialog("Not implemented yet");
        }

        return null;
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->vod->folder_entered($media_url, $plugin_cookies);

        $this->vod->ensure_genres_loaded($plugin_cookies);

        $genre_ids = $this->vod->get_genre_ids();

        $items = array();

        foreach ($genre_ids as $genre_id)
        {
            $caption = $this->vod->get_genre_caption($genre_id);
            $media_url_str = $this->vod->get_genre_media_url_str($genre_id);
            $icon_url = $this->vod->get_genre_icon_url($genre_id);

            $items[] = array
            (
                PluginRegularFolderItem::media_url => $media_url_str,
                PluginRegularFolderItem::caption => $caption,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $icon_url,
                )
            );
        }

        return $items;
    }

    public function get_archive(MediaURL $media_url)
    {
        return $this->vod->get_archive($media_url);
    }
}

?>
